import { Injectable } from '@angular/core'

import { LogLevel } from '../logger/log-level'
import { LocalConfig } from './local-config'
import { ConfigApiService } from './config-api.service'

enum Config {
    EnableApiLogging,
    LogLevel,
    SecondsForExternalRedirect,
    ContactsUrl,
    ApiServer,
    LocalDomains,
    //+ keep at end; don't interfere with auto-number
    _TestNumericValue,
    _TestArrayValue
}

@Injectable()
class ConfigService {
    constructor(private configApiService: ConfigApiService) {
    }

    public async setDefaults() {
        if (!LocalConfig.UseConfigApiService) {
            return
        }
        console.log('ConfigService::setDefaults')
        try {
            await (this.configApiService.get('LogLevel').toPromise())
        }
        catch (ex) {
            await this.configApiService.update('LogLevel', LocalConfig.Defaults.LogLevel)
        }
        try {
            await (this.configApiService.get('SecondsForExternalRedirect').toPromise())
        }
        catch (ex) {
            await this.configApiService.update('SecondsForExternalRedirect', LocalConfig.Defaults.SecondsForExternalRedirect)
        }
        // try {
        //     await (this.configApiService.get('ApiServer').toPromise())
        // }
        // catch (ex) {
        //     await this.configApiService.update('ApiServer', LocalConfig.Defaults.ApiServer)
        // }
        try {
            await (this.configApiService.get('LocalDomains').toPromise())
        }
        catch (ex) {
            await this.configApiService.update('LocalDomains', LocalConfig.Defaults.LocalDomains)
        }
    }

    public async load(config: Config) {
        let name: string = Config[config]
        // console.log('ConfigService::load|LocalConfig.UseConfigApiService:' + LocalConfig.UseConfigApiService)
        if (typeof config == 'undefined') {
            return ''
        }
        if (LocalConfig.UseConfigApiService) {
            if (LocalConfig.DataProvider !== "http") {
                const value = await this.configApiService.get(name)
                // const value = JSON.parse(<string>(await this.configApiService.get(name)))
                return value
            }
            else {
                const value = JSON.parse(<string>(await (this.configApiService.get(name).toPromise())))
                return value
            }
        }
        else {
            switch (config) {
                case Config._TestNumericValue:
                    return 42
                case Config._TestArrayValue:
                    return [1, 2, 3, 4]
                case Config.EnableApiLogging:
                    return true
                case Config.LogLevel:
                    return LogLevel.Info
                case Config.SecondsForExternalRedirect:
                    return 20
                case Config.ApiServer:
                    return "http://mccf.local:8193"
                case Config.ContactsUrl:
                    return "http://swapi.co/api/people/"
                case Config.LocalDomains:
                    return [0, 1, 2, 3, 4, 5, 6].map(p => 'http://localhost:420' + p)
            }
        }
    }
}

export {
    Config,
    ConfigService
}
